/****************************************************************************
* Donohue and Wolfers (2006) 
* Figure 1
* Homicides and Execution in the United States
****************************************************************************/

clear
cd"..."
use "Homicides and execution - US time series.dta", clear

gen ehrlich=-.5 if year>=1933 & year<=1969
gen taylor=-1.5 if year>=1935 & year<=1962                  
gen shepherd=-2.5 if year>=1960 & year<=2000

#delimit;
twoway 
	(line homicide_vs_eckberg year, sort lcolor(navy) lpattern(solid)) 
	(line homicide_fbi year, sort lcolor(blue) lpattern(solid) lwidth(thin)) 
	(line ehrlich year, lcolor(black) lwidth(vvthin))
	(line taylor year, lcolor(black) lwidth(vvthin))
	(line shepherd year, lcolor(black) lwidth(vvthin))
	(line executions year, yaxis(2) lcolor(cranberry) lpattern(dash)), 
	ylabel(-2.5 " " 0(2.5)12.5, angle(horizontal))
	ylabel(-.05 " " 0(.05).25, angle(horizontal) axis(2))
	xtitle("")
	ytitle("Homicides per 100,000 residents")
	ytitle("Executions per Homicide", axis(2))
	title(Homicide and Execution in the United States) 
	legend(rows(3) ring(0) pos(12) order(6 "Execution rate (right axis)" 1 "Homicide rate: Vital Statistics, corrected" 2 "Homicide rate: FBI") size(small))
	legend(region(lcolor(none) fcolor(none)))
	text(-0.25 1951 "Ehrlich's sample", size(small))
	text(-1.20 1947.5 "Passell & Taylor's sample", size(small))
	text(-2.25 1980 "Dezhbakhsh & Shepherd's sample", size(small))
	xsize(10) ysize(7.5)
;






